/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.usage.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IOUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.usage.AnalyticsEvent;
import com.aptana.usage.IAnalyticsLogger;
import com.aptana.usage.UsagePlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyticsLogger
implements IAnalyticsLogger {
    private final IPath directory;

    public AnalyticsLogger(IPath directory) {
        this.directory = directory;
        if (!this.directory.toFile().isDirectory()) {
            this.directory.toFile().mkdirs();
        }
    }

    @Override
    public synchronized void logEvent(AnalyticsEvent event) {
        block12: {
            OutputStreamWriter writer = null;
            try {
                try {
                    writer = new FileWriter(this.getFile(event));
                    writer.write(event.toJSON());
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)UsagePlugin.getDefault(), (String)MessageFormat.format("Unable to persist analytics event to disk! Event: {0}", event.toJSON()));
                    if (writer == null) break block12;
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public synchronized void clearEvents() {
        File[] files;
        File[] fileArray = files = this.directory.toFile().listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.delete()) {
                file.deleteOnExit();
            }
            ++n2;
        }
    }

    private File getFile(AnalyticsEvent event) {
        return this.directory.append(String.valueOf(event.hashCode()) + ".json").toFile();
    }

    @Override
    public synchronized void clearEvent(AnalyticsEvent event) {
        File file = this.getFile(event);
        if (file.isFile() && !file.delete()) {
            file.deleteOnExit();
        }
    }

    @Override
    public synchronized List<AnalyticsEvent> getEvents() {
        File[] files = this.directory.toFile().listFiles();
        if (files == null || files.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<AnalyticsEvent> events = new ArrayList<AnalyticsEvent>(files.length);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block17: {
                File file = fileArray[n2];
                FileInputStream stream = null;
                try {
                    try {
                        stream = new FileInputStream(file);
                        String json = IOUtil.read((InputStream)stream);
                        if (!StringUtil.isEmpty((String)json)) {
                            events.add(AnalyticsEvent.fromJSON(json));
                        }
                    }
                    catch (FileNotFoundException e) {
                        IdeLog.logWarning((Plugin)UsagePlugin.getDefault(), (Throwable)e);
                        if (stream != null) {
                            try {
                                ((InputStream)stream).close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (stream != null) {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            ++n2;
        }
        events.trimToSize();
        return events;
    }
}

